/****************************************************************************/
/*                                                                          */
/* Name      :  HS_ZP3XApi.h                                                */
/* Autor     :  Joerg Heidrich                                              */
/* Inhalt    :  Schnittstellen-Headerdatei der DLL                          */
/*              fr Zhlerkarten ZP088,...                                  */
/*              (Erweiterte Funktionen)                                     */
/*                                                                          */
/* (c) Heilig & Schwab GmbH                                                 */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/* Aenderungen                                              Datum    Name   */
/*--------------------------------------------------------------------------*/
/* Originalimplementierung                                  13.08.98    jh  */
/* Referenz zurcksetzen	                                13.09.01    jh  */
/* Aktuellen Zhlerwert liefern                             13.09.01    jh  */
/* Stop-Zustand liefern		                                13.09.01    jh  */
/* Zhler stoppen bei beiden Flanken						14.03.02	jh	*/
/* Stop-Bit transparent liefern                             15.03.02    jh  */
/* Abstandscodierte Referenzauswertung                      05.11.02    jh  */
/* Abstandscodierte Referenzauswertung einstellbar          05.02.03    jh  */
/* Einstellbare Grundzhlrichtung fr Abstandscodierung     21.02.03    jh  */
/* Gemeinsames Stoppen aller Zhler auf allen Karten        26.06.03    jh  */
/*                                                                          */
/****************************************************************************/

// Konstanten fr den Referenzmode
#define ZP_NO_REF           0         // Ohne Referenz
#define ZP_ONE_REF          1         // Einfach Referenz
#define ZP_MULTI_REF        2         // Mehrfach Referenz
#define ZP_CODED_REF        3         // Abstandscodierte Referenz

// Konstanten fr den Stopmode
#define ZP_NO_STOP        0x00        // Ohne Stop
#define ZP_MANU_STOP      0x01        // Manueller Stop
#define ZP_AUTO_STOP      0x02        // Automatischer Stop
#define ZP_STOP_RISE	  0x00		  // Zhler stoppen bei steigender Flanke	
#define ZP_STOP_FALL	  0x10		  // Zhler stoppen bei fallender Flanke	
#define ZP_STOP_RISE_FALL 0x20		  // Zhler stoppen bei fallender und steigender Flanke	

// Statusbits
#define ZP_ERROR          0x01        // Fehlerbit
#define ZP_REF            0x02        // Referenzbit
#define ZP_STOP           0x04        // Stopbit
#define ZP_STOP_STATE     0x08        // Stopbit Zustand
#define ZP_STOP_TRANS     0x10        // Stopbit Transparent

// Konstanten fr die Grundzhlrichtung
#define ZP_DIR_POS          0         // Positive Grundzhlrichtung
#define ZP_DIR_NEG          1         // Negative Grundzhlrichtung

#ifdef __cplusplus
  extern "C" {
#endif  /* __cplusplus */

// Funktionen
long FAR PASCAL EXPORT HS_ZP3X_Initialize(long CardNo);

long FAR PASCAL EXPORT HS_ZP3X_GetVersion(char* DriverVersion,
                                          char* DllVersion);

long FAR PASCAL EXPORT HS_ZP3X_SetMode(long CardNo,
                                       long CounterNo,
                                       long RefMode,
                                       long StopMode);

long FAR PASCAL EXPORT HS_ZP3X_SetCounterMul(long CardNo,
                                             long CounterNo,
                                             long Multiplier);

long FAR PASCAL EXPORT HS_ZP3X_GetCounter(long CardNo,
                                          long CounterNo,
                                          long *Count,
                                          long *Status);

long FAR PASCAL EXPORT HS_ZP3X_GetAllCounter(long CardNo,
                                             long *Count1,
                                             long *Status1,
                                             long *Count2,
                                             long *Status2,
                                             long *Count3,
                                             long *Status3);

long FAR PASCAL EXPORT HS_ZP3X_ResetCounterStop(long CardNo,
                                                long CounterNo);

long FAR PASCAL EXPORT HS_ZP3X_ResetRef(long CardNo,
                                        long CounterNo);

long FAR PASCAL EXPORT HS_ZP3X_GetCounterCurrent(long CardNo,
												 long CounterNo,
												 long *Count,
												 long *Status);

long FAR PASCAL EXPORT HS_ZP3X_GetAllCounterCurrent(long CardNo,
													long *Count1,
													long *Status1,
													long *Count2,
													long *Status2,
													long *Count3,
													long *Status3);

long FAR PASCAL EXPORT HS_ZP3X_SetDistCode(long CardNo,
                                           long CounterNo,
                                           long Distance,
                                           long Pitch,
                                           long Offset,
                                           long Direction);

long FAR PASCAL EXPORT HS_ZP3X_StopAllCounter(long CardNo);

#ifdef __cplusplus
  }
#endif
